#pragma once

#include <yxiva/core/types.h>
#include <yxiva/core/json/include.h>

namespace yxiva { namespace resharding {

struct migration
{
    enum class state_type
    {
        pending,
        ready,
        inprogress,
        finished
    };

    state_type state;
    gid_t start_gid;
    gid_t end_gid;

    string describe() const;
    json_value to_json() const;
};

using migrations = std::vector<migration>;

json_value to_json(const migrations& migrations);

bool operator==(const migration& lhs, const migration& rhs);
bool operator!=(const migration& lhs, const migration& rhs);
bool operator<(const migration& lhs, const migration& rhs);
const string& to_string(migration::state_type state);

}}