#pragma once

#include <ymod_webserver/request.h>
#include <yxiva/core/types.h>
#include <yxiva/core/message.h>
#include <yxiva/core/iabstract.h>

namespace yxiva { namespace services {

/** Decodes a notification message from a request body
 */
class decoder_interface : public iabstract
{
public:
    virtual void decode(const ymod_webserver::request_ptr& req, message& msg) const = 0;
};

typedef shared_ptr<decoder_interface> decoder_ptr;

typedef std::map<std::string, decoder_ptr> decoders_kit;
typedef shared_ptr<decoders_kit> decoders_kit_ptr;

}}
