#pragma once

#include <yxiva/core/json/include.h>
#include <yxiva/core/gid.h>
#include <yxiva/core/operation_result.h>
#include <yxiva/core/types.h>
#include <boost/functional/hash.hpp>
#include <boost/optional.hpp>
#include <unordered_set>
#include <ostream>

namespace yxiva { namespace shard_config {

struct db_instance
{
    string conninfo;
};

using db_instances = std::vector<db_instance>;
using id_t = uint32_t;
struct shard
{
    id_t id;
    gid_t start_gid;
    gid_t end_gid;
    db_instance master;
    db_instances replicas;

    string describe() const;
    json_value to_json() const;
};

using shards = std::vector<shard>;

boost::optional<const shard&> shard_from_id(const shards& shards, id_t id);
boost::optional<const shard&> shard_from_gid(const shards& shards, gid_t gid);
inline boost::optional<const shard&> shard_from_uid(const shards& shards, const string& uid)
{
    return shard_from_gid(shards, gid_from_uid(uid));
}

boost::optional<const db_instance&> master_from_gid(const shards& shards, gid_t gid);
boost::optional<const db_instance&> random_replica_from_gid(const shards& shards, gid_t gid);

inline boost::optional<const db_instance&> master_from_uid(const shards& shards, const string& uid)
{
    return master_from_gid(shards, gid_from_uid(uid));
}
inline boost::optional<const db_instance&> random_replica_from_uid(
    const shards& shards,
    const string& uid)
{
    return random_replica_from_gid(shards, gid_from_uid(uid));
}

json_value to_json(const shards& shards);

bool operator==(const db_instance& lhs, const db_instance& rhs);
bool operator!=(const db_instance& lhs, const db_instance& rhs);

bool operator==(const shard& lhs, const shard& rhs);
bool operator!=(const shard& lhs, const shard& rhs);

}}
