#pragma once

#include <yxiva/core/subscriptions.h>

namespace yxiva {

string make_subscription_id(
    const string& uid,
    const string& service,
    const string& callback,
    const string& client,
    const string& session,
    const string& filter,
    const string& extra);
string make_subscription_id(const sub_t& subscription);
string make_mobile_subscription_id(const string& device_uuid);
string make_webpush_subscription_id(const string& session);

namespace websocket_id_generator {

string make_default(
    const string& uid,
    const string& service,
    const string& callback,
    const string& client,
    const string& session,
    const string& filter,
    const string& extra);

string make_from_session(
    const string& uid,
    const string& service,
    const string& callback,
    const string& client,
    const string& session,
    const string& filter,
    const string& extra);

}

}
