#pragma once

#include <boost/shared_ptr.hpp>
#include <boost/serialization/strong_typedef.hpp>
#include <boost/functional/hash.hpp>
#include <boost/shared_ptr.hpp>
#include <boost/algorithm/string.hpp>
#include <boost/algorithm/string/join.hpp>
#include <boost/range/iterator_range.hpp>

#include <msgpack.hpp>
#include <yplatform/string_config.h>
#include <yplatform/log.h>
#include <yplatform/module.h>
#include <yplatform/task_context.h>
#include <yplatform/exception.h>
#include <yplatform/time_traits.h>
#include <yplatform/net/types.h>
#include <yplatform/future/future.hpp>

#include <string>
#include <string_view>
#include <mutex>
#include <shared_mutex>

#define SERVICES_LOG(ctx, level) TASK_LOG(ctx, level) << "yxiva_services "

namespace yxiva {

using std::string;
using std::string_view;
using std::wstring;
using namespace std::literals::string_literals;

using yplatform::task_context;
using yplatform::task_context_ptr;

using std::auto_ptr;
using boost::shared_ptr;
using boost::weak_ptr;
using boost::make_shared;
using boost::enable_shared_from_this;
using boost::make_shared;
using yplatform::shared_from;

typedef shared_ptr<string> string_ptr;
typedef shared_ptr<wstring> wstring_ptr;

using yplatform::future::future;
using yplatform::future::promise;
typedef yplatform::future::promise<void> promise_void_t;
typedef yplatform::future::future<void> future_void_t;

using std::mutex;
using scoped_lock = std::unique_lock<mutex>;
using std::shared_mutex;
using write_lock = std::unique_lock<shared_mutex>;
using read_lock = std::shared_lock<shared_mutex>;

using yplatform::net::timer_ptr;

typedef yplatform::time_traits::duration time_duration;
typedef yplatform::time_traits::time_point time_point;
using yplatform::time_traits::clock;
using yplatform::time_traits::duration_cast;
using yplatform::time_traits::hours;
using yplatform::time_traits::minutes;
using yplatform::time_traits::seconds;
using yplatform::time_traits::float_seconds;
using yplatform::time_traits::milliseconds;
using steady_timer = yplatform::time_traits::timer;
using yplatform::time_traits::get_seconds_count;

namespace time_traits = yplatform::time_traits;

using boost::system::error_code;

template <typename Future>
string get_exception_reason(Future& val)
{
    if (!val.has_exception()) return "no exceptions";

    try
    {
        val.get();
    }
    catch (yplatform::exception& e)
    {
        return e.public_message();
    }
    catch (std::exception& err)
    {
        return err.what();
    }
    catch (...)
    {
    }
    return "unknown";
}

BOOST_STRONG_TYPEDEF(string, user_id);
BOOST_STRONG_TYPEDEF(string, service_user_id); // DEPRECATED

inline std::ostream& operator<<(std::ostream& ostr, const user_id& uid)
{
    return ostr << static_cast<string>(uid);
}
inline std::ostream& operator<<(std::ostream& ostr, const service_user_id& suid)
{
    return ostr << static_cast<string>(suid);
}

BOOST_STRONG_TYPEDEF(string, service_name);

typedef uint32_t ttl_t;
typedef uint64_t local_id_t;

typedef std::string filter_t;

inline std::ostream& operator<<(std::ostream& ostr, const service_name& name)
{
    return ostr << static_cast<string>(name);
}

constexpr char TOPIC_PREFIX[] = "topic:";
constexpr auto TOPIC_PREFIX_SZ = sizeof(TOPIC_PREFIX) / sizeof(char) - 1;

inline string encode_topic_name(const string& src)
{
    string result;
    result.reserve(TOPIC_PREFIX_SZ + src.size());
    result.append(TOPIC_PREFIX).append(src);
    return result;
}

inline bool is_topic_name(const string& src)
{
    return src.compare(0, TOPIC_PREFIX_SZ, TOPIC_PREFIX) == 0;
}

// check with is_topic_name() before decoding
inline boost::iterator_range<string::const_iterator> decode_topic_name(const string& src)
{
    assert(src.size() >= TOPIC_PREFIX_SZ);
    return boost::make_iterator_range(src.begin() + TOPIC_PREFIX_SZ, src.end());
}

}
