#pragma once

#include <yxiva/core/types.h>

namespace yxiva {

struct user_info
{
    explicit user_info(const user_id& uid_) : uid(uid_)
    {
    }

    user_info(const string& db, int tz) : mdb(db), timezone_offset(tz)
    {
    }

    user_info() = default;

    yxiva::user_id uid;
    yxiva::service_user_id suid; // @todo mark deprecated
    string mdb;
    int timezone_offset{ 10800 }; // default timezone
};

struct auth_info
{
    std::vector<user_info> users;
    string bb_connection_id;
};

}
