#pragma once

#include <yxiva/core/operation_result.h>
#include <yxiva/core/types.h>

#include <memory>

#include <openssl/x509.h>

namespace yxiva { namespace x509 {

enum class attribute_type : int
{
    country_name = NID_countryName,
    organization_name = NID_organizationName,
    organizational_unit_name = NID_organizationalUnitName,
    common_name = NID_commonName,
    user_id = NID_userId
};

class certificate
{
public:
    certificate(X509* cert);
    certificate(X509* cert, EVP_PKEY* private_key);

    operation::result issuer_text(attribute_type attr, string& text);
    operation::result subject_text(attribute_type attr, string& text);
    operation::result expiration_ts(int64_t& ts);

    operation::result up_to_date();

    operation::result write_pem(BIO* bio);

    certificate(const certificate& other) = delete;
    certificate(certificate&& other) = default;

    certificate& operator=(const certificate& other) = delete;
    certificate& operator=(certificate&& other) = default;

private:
    operation::result read_x509_text(X509_NAME* name, int nid, string& text);

    std::unique_ptr<X509, void (*)(X509*)> cert_;
    std::unique_ptr<EVP_PKEY, void (*)(EVP_PKEY*)> pkey_;
};

using certificate_chain = std::vector<certificate>;

bool contains_pem(const char* data, std::size_t size);

operation::result parse_pem(const char* data, std::size_t size, X509*& cert);
operation::result parse_p12(
    const char* data,
    std::size_t size,
    const string& password,
    certificate_chain& certs);
operation::result parse_private_key(const char* data, std::size_t size, EVP_PKEY*& private_key);

operation::result write_pem(certificate_chain& certs, string& buffer);

}}
