from nose.tools import *

def fail_(msg=None):
    raise AssertionError(msg)

def assert_code_msg(resp, code, msg):
    eq_(resp.status, code)
    if msg:
        eq_(resp.body, msg)

def assert_ok(resp, msg=None):
    assert_code_msg(resp, 200, msg)

def assert_bad_request(resp, msg=None):
    assert_code_msg(resp, 400, msg)

def assert_internal_server_error(resp, msg=None):
    assert_code_msg(resp, 500, msg)

def assert_bad_gateway_error(resp, msg=None):
    assert_code_msg(resp, 502, msg)

def assert_gateway_timeout_error(resp, msg=None):
    assert_code_msg(resp, 504, msg)

def assert_unauthorized(resp, msg='Unauthorized'):
    assert_code_msg(resp, 401, msg)

def assert_ws_ok(resp, ws):
    eq_(resp.code, 101)
    ws_message = ws.recv_message()
    assert_not_equal(ws_message, None)
    eq_(ws_message.status_code, 0)

def assert_ws_unauthorized(resp, ws, msg=None):
    eq_(resp.code, 101)
    ws_message = ws.recv_message()
    assert_not_equal(ws_message, None)
    eq_(ws_message.status_code, 4401)
    if msg != None:
        eq_(ws_message.payload, msg)

def assert_ws_bad_request(resp, ws, msg=None):
    eq_(resp.code, 101)
    ws_message = ws.recv_message()
    assert_not_equal(ws_message, None)
    eq_(ws_message.status_code, 4400)
    if msg != None:
        eq_(ws_message.payload, msg)
