#!/usr/bin/env python2

import re
import sys
import json
from nose.tools import *
from urlparse import urlparse, parse_qs

def neq_(a,b):
    assert_not_equal(a,b)

def assert_ok(resp, msg = None):
    eq_(resp.status, 200)
    if msg:
        eq_(resp.body, msg)

def assert_bad_request(resp, msg = None):
    eq_(resp.status, 400)
    if msg:
        eq_(resp.body, msg)

def assert_not_found(resp):
    eq_(resp.status, 404)

def assert_unauthorized(resp, msg='Unauthorized'):
    eq_(resp.status, 401)
    eq_(resp.body, msg)

def assert_unauthorized_json(resp, msg='Unauthorized'):
    eq_(resp.status, 401)
    if type(msg) is dict:
        to_compare = msg
    else:
        to_compare = json.loads(msg)
    eq_(json.loads(resp.body), to_compare)

def assert_gone(resp):
    eq_(resp.status, 410)

def assert_internal_error(resp, msg = None):
    eq_(resp.status, 500)
    if msg:
        eq_(resp.body, msg)

def assert_ws_ok(resp, ws, expect_greeting = True):
    eq_(resp.code, 101)
    if expect_greeting:
        ws_message = ws.recv_message()
        if ws_message:
            print ws_message.status_code
            print ws_message.payload
            assert_not_equal(ws_message, None)
            eq_(ws_message.status_code, 0)

def assert_ws_unauthorized(resp, ws, msg=None):
    eq_(resp.code, 101)
    ws_message = ws.recv_message()
    assert_not_equal(ws_message, None)
    eq_(ws_message.status_code, 4401)
    if msg != None:
        eq_(ws_message.payload, msg)

def assert_ws_forbidden(ws, msg=None):
    ws_message = ws.recv_message()
    assert_not_equal(ws_message, None)
    eq_(ws_message.status_code, 4403)
    if msg != None:
        eq_(ws_message.payload, msg)

def assert_ws_bad_request(resp, ws, msg=None):
    eq_(resp.code, 101)
    ws_message = ws.recv_message()
    assert_not_equal(ws_message, None)
    eq_(ws_message.status_code, 4400)
    if msg != None:
        eq_(ws_message.payload, msg)

def assert_no_ws_message(ws):
    ws_message = ws.recv_message()
    if ws_message:
        print 'payload:', ws_message.payload
    assert_equal(ws_message, None)

def assert_ws_message(ws_message, status, text):
    assert_not_equal(ws_message, None)
    eq_(ws_message.status_code, status)
    eq_(ws_message.payload, text)

def assert_ws_message_json(ws_message, status, text):
    assert_not_equal(ws_message, None)
    eq_(ws_message.status_code, status)
    if type(text) is dict:
        to_compare = text
    else:
        to_compare = json.loads(text)
    eq_(json.loads(ws_message.payload), to_compare)

def assert_messages_equal(a, b):
    eq_(a[:14], b[:14])

def assert_regexp_in(pattern, string):
    r = re.compile(pattern)
    if r.search(string) is None:
        raise AssertionError("Pattern '%s' not found in '%s'" % (pattern, string, ))

def check_caught_request(req, path, **getargs):
    check_caught_request_impl(req, path, True, **getargs)

def check_caught_request_binary_body(req, path, **getargs):
    check_caught_request_impl(req, path, False, **getargs)

def check_caught_request_impl(req, path, body_contains_args, **getargs):
    try:
        post_args = parse_qs(urlparse("?"+req.body).query) if body_contains_args else {}
    except:
        post_args = {}
    r = urlparse(req.path)
    query = parse_qs(r.query)
    eq_(r.path, path)
    for key in getargs:
        val = getargs[key]
        if val:
            ok_(key in query or key in post_args, 'No parameter %s in query %s %s' % (key, json.dumps(query), json.dumps(post_args)))
            request_val = post_args.get(key,None) or query[key]
            request_val = request_val[0]
            if isinstance(val, list):
                ok_(request_val in val, 'Invalid argument "%s" must be one of: %s' % (request_val, ','.join(val)))
            else:
                eq_(request_val, val)
        else:
            ok_(key not in query, 'Parameter %s shoudn\'t be in query' % key)

def assert_content_type_equals(req, content_type):
    assert_in("content-type", req.headers)
    eq_(req.headers['content-type'], content_type)
