#!/usr/bin/env python2

import sys
import urllib
import socket
import BaseHTTPServer
import json
import itertools
from threading import Thread

class Request:
    def __init__(self):
        self.path = ''
        self.body = ''

class Response:
    def __init__(self, code = 200, reason = 'OK', body = '', headers={}):
        self.code = code
        self.reason = reason
        self.body = body
        self.headers = headers

class BaseIPV6Server(BaseHTTPServer.HTTPServer, object):
    address_family = socket.AF_INET6
    timeout = 1
    def __init__(self, *args, **kwargs):
        super(BaseIPV6Server, self).__init__(*args, **kwargs)
        self.response = Response()
        self.response_chain = [] # raw body queue to respond prior to self.response.body
        self.hook = None
        self.error_in_hook = False
        self.thread = None
        self.emulate_unresponsive_server = False
        self.counter = itertools.count()
        self.total_requests = self.counter.next()
        self.fail_strategy = []

    def set_response(self, response=None, raw_response=None, headers=None):
        if raw_response:
            self.response.body = raw_response
        elif response:
            self.response.body = "".join(open(response).readlines())
        else:
            self.response.body = ''

        if  headers:
            self.response.headers = headers

    def set_response_code(self, code, reason=None):
        assert(isinstance(code, int))
        self.response.code = code
        self.response.reason = reason

    def set_request_hook(self, hook):
        error_in_hook = self.error_in_hook
        self.hook = hook
        self.error_in_hook = None
        return error_in_hook

    def response_chain_append(self, response):
        self.response_chain.append(response)

    def response_chain_clear(self):
        self.response_chain = []

    def reset_state(self):
        self.fail_strategy = []
        self.counter = itertools.count()
        self.total_requests = self.counter.next()

    def set_fail_strategy(self, strategy):
        self.fail_strategy = strategy

    def server_bind(self):
        BaseHTTPServer.HTTPServer.server_bind(self)
        self.allow_reuse_address = True
        self.socket.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEADDR, 1)

    def async_serve_forever(self):
        print 'serve forever'
        self.thread = Thread(target=self.serve_forever)
        self.thread.daemon = True
        self.thread.start()

    def start(self):
        print 'start'
        self.async_serve_forever()

    def process_request(self, request, client_address):
        do_fail = self.total_requests in self.fail_strategy
        self.total_requests = self.counter.next()
        if (self.emulate_unresponsive_server):
            handler = UnresponsiveHandler(request, client_address, self)
        elif do_fail:
            handler = FailHandler(request, client_address, self)
        else:
            handler = self.RequestHandlerClass(request, client_address, self)
        handler.setup()
        req = Request()
        req.path = handler.path
        req.headers = handler.headers
        if hasattr(handler, 'body'):
            req.body = handler.body
        if self.hook:
            try:
                self.hook(req)
            except Exception as ex:
                self.error_in_hook = ex
                raise
        handler.handle()
        handler.finish()

    def fini(self):
        self.shutdown()
        self.server_close()

class BasicHandler(BaseHTTPServer.BaseHTTPRequestHandler):
    def do_POST(self):
        self.body = self.rfile.read(int(self.headers.getheader('content-length', 0)))
        return self.do_GET()

    def log_message(self, format, *args):
        return

class UnresponsiveHandler(BasicHandler):
    def do_GET(self):
        return ''

class FailHandler(BasicHandler):
    def do_GET(self):
        self.protocol_version = 'HTTP/1.1'
        self.send_response(500, 'InternalServerError')
        self.send_header('Content-Length', 1)
        self.send_header('Connection', 'close')
        self.end_headers()
        self.wfile.write("0")
        return ''

class ChunkedRequestHandler(BasicHandler):
    def do_GET(self):
        if not self.server.response_chain:
            response = self.server.response
        else:
            response = self.server.response_chain[0]
            self.server.response_chain.pop(0)
        self.protocol_version = 'HTTP/1.1'
        self.send_response(response.code, response.reason)
        self.send_header('Transfer-Encoding', 'chunked')
        self.send_header('Connection', 'close')
        for header,value in response.headers.iteritems():
            self.send_header(header, value)
        self.end_headers()
        self.wfile.write('%x\r\n' % len(response.body))
        self.wfile.write(response.body)
        self.wfile.write('\r\n%x\r\n\r\n' % 0)
        return ''

class RequestHandler(BasicHandler):
    def do_GET(self):
        if not self.server.response_chain:
            response = self.server.response
        else:
            response = self.server.response_chain[0]
            self.server.response_chain.pop(0)
        self.protocol_version = 'HTTP/1.1'
        self.send_response(response.code, response.reason)
        self.send_header('Content-Length', len(response.body))
        self.send_header('Connection', 'close')
        for header,value in response.headers.iteritems():
            self.send_header(header, value)
        self.end_headers()
        self.wfile.write(response.body)
        return ''

def make_server(handler, host, port, response=None, raw_response=None, start=True):
    httpd = BaseIPV6Server((host, port), handler)
    httpd.set_response(response, raw_response)
    if start:
        httpd.start()
    return httpd


def fake_chunked_server(**kwargs):
    handler = ChunkedRequestHandler
    return make_server(ChunkedRequestHandler, **kwargs)

def fake_server(**kwargs):
    return make_server(RequestHandler, **kwargs)

if __name__ == "__main__":
    try:
        host = sys.argv[1]
        port = sys.argv[2]
        port = int(port)
        answer = sys.argv[3]
        fake_chunked_server(host=host, port=port, response=answer).serve_forever()
    except KeyboardInterrupt:
        pass
