#!/usr/bin/env python2

import httplib
import urllib
import json
import msgpack
from select import select
import struct
import types
import os

class HTTPRaw(object):
    """ GET/POST requests helper """
    def __init__(self, host, port):
        self.host = host
        self.port = port
        print('http client on %s:%s inited' % (host, port))

    def GET(self, url, headers):
        conn = httplib.HTTPConnection(self.host, self.port)
        conn.request("GET", url, "", headers)
        print('request: GET %s %s' % (url, '\n'.join(['%s: %s' % (key, headers[key]) for key in headers])))
        resp = conn.getresponse()
        resp.body = resp.read(resp.getheader("content-length"))
        resp.code = resp.status
        resp.headers = self.array_to_dict(resp.getheaders())
        print('response: %d %s, ctx: %s' % (resp.status, resp.body, resp.headers["y-context"]))
        return resp

    def POST(self, url, headers={}, body=""):
        conn = httplib.HTTPConnection(self.host, self.port)
        conn.request("POST", url, body, headers)
        print('request: POST %s %s %s' % (url, '\n'.join(['%s: %s' % (key, headers[key]) for key in headers]), body))
        resp = conn.getresponse()
        resp.body = resp.read(resp.getheader("content-length"))
        resp.headers = self.array_to_dict(resp.getheaders())
        print('response: %d %s, ctx: %s' % (resp.status, resp.body, resp.headers["y-context"]))
        return resp

    def array_to_dict(self, array):
        result = dict()
        for a in array:
            result[a[0]] = a[1]
        return result


class XivamobAPI(HTTPRaw):
    def __init__(self, **kwargs):
        if 'host' not in kwargs:
            kwargs['host'] = os.environ["XTEST_HOST"]
        if 'port' not in kwargs:
            kwargs['port'] = os.environ["XTEST_PORT"]
        super(self.__class__, self).__init__(**kwargs)

    def prepare_url(self, url, **getparams):
        if 'payload' in getparams:
            if isinstance(getparams['payload'], dict):
                getparams['payload'] = json.dumps(getparams['payload'])
        params = [(key, getparams[key]) for key in getparams if getparams[key]]
        quoted_params = urllib.urlencode(params)
        return url + quoted_params

    def send_apns(self, **getparams):
        return self.send('push/apns', **getparams)

    def send_gcm(self, **getparams): # gcm_compatibility
        return self.send('push/gcm', **getparams) # gcm_compatibility

    def send_fcm(self, **getparams):
        return self.send('push/fcm', **getparams)

    def send_hms(self, **getparams):
        return self.send('push/hms', **getparams)

    def send_wns(self, **getparams):
        return self.send('push/wns', **getparams)

    def send_mpns(self, **getparams):
        return self.send('push/mpns', **getparams)

    def send_webpush(self, **getparams):
        return self.send('webpush', **getparams)

    def send_batch_gcm(self, **getparams): # gcm_compatibility
        return self.send('batch_push/gcm', **getparams) # gcm_compatibility

    def send_batch_fcm(self, **getparams):
        return self.send('batch_push/fcm', **getparams)

    # get-params can be: app, token, payload, ttl, x-<anything>
    def send(self, platform, **getparams):
        url = '/%s?' % platform
        resp = self.POST(self.prepare_url(url, **getparams))
        return resp

    def check(self, platform, **getparams):
        url = '/check/%s?' % platform
        resp = self.POST(self.prepare_url(url, **getparams))
        return resp

    def check_fcm(self, **getparams):
        return self.check('fcm', **getparams)
