#include <yxiva/core/auth/authorizer.h>
#include <yxiva/core/auth/error.h>
#include <yplatform/find.h>

namespace yxiva {

enum bb_sid
{
    bb_sid_mail = 2,
    bb_sid_disk = 59
};

user_info_future_t authorizer_blackbox::authenticate(
    task_context_ptr ctx,
    const address& user_address,
    const string& login)
{
    user_info_promise_t result;
    auth_request_t req;
    req.context = ctx;
    req.no_password = true;
    req.username = login;
    req.service = "2";
    req.address = user_address;
    req.load_timezone = true;
    req.sids_to_check.push_back(bb_sid_disk);
    auth_future_t aresp = yplatform::find<ymod_blackbox::auth>("auth")->authenticate(req);
    aresp.add_callback(boost::bind(
        &authorizer_blackbox::auth_cb,
        shared_from_this(),
        ctx,
        aresp,
        result,
        time_traits::clock::now()));
    return result;
}

user_info_future_t authorizer_blackbox::authenticate(
    task_context_ptr ctx,
    const address& user_address,
    const service_user_id& suid)
{
    user_info_promise_t result;
    auth_request_t request(ctx, suid, 2, user_address);
    request.load_timezone = true;
    request.sids_to_check.push_back(bb_sid_disk);
    auth_future_t aresp = yplatform::find<ymod_blackbox::auth>("auth")->authenticate(request);
    aresp.add_callback(boost::bind(
        &authorizer_blackbox::auth_cb,
        shared_from_this(),
        ctx,
        aresp,
        result,
        time_traits::clock::now()));
    return result;
}

user_info_future_t authorizer_blackbox::authenticate(
    task_context_ptr ctx,
    const address& user_address,
    const user_id& uid)
{
    user_info_promise_t result;
    auth_request_t request(ctx, static_cast<string>(uid), 2);
    request.address = user_address;
    request.load_timezone = true;
    request.sids_to_check.push_back(bb_sid_mail);
    request.sids_to_check.push_back(bb_sid_disk);
    auth_future_t aresp = yplatform::find<ymod_blackbox::auth>("auth")->authenticate(request);
    aresp.add_callback(boost::bind(
        &authorizer_blackbox::auth_cb,
        shared_from_this(),
        ctx,
        aresp,
        result,
        time_traits::clock::now()));
    return result;
}

void authorizer_blackbox::auth_cb(
    task_context_ptr ctx,
    auth_future_t fres,
    user_info_promise_t result,
    time_traits::time_point start_time)
{
    if (fres.has_exception())
    {
        result.set_exception(authorizer_error(get_exception_reason(fres)) << BOOST_ERROR_INFO);
        return;
    }
    auth_response_t aresp = fres.get();
    if (!aresp.success)
    {
        result.set_exception(authorizer_error(aresp.err_str) << BOOST_ERROR_INFO);
        return;
    }
    user_info result_info;
    if (aresp.uid.empty())
    {
        result.set_exception(no_such_user() << BOOST_ERROR_INFO);
        return;
    }
    string time_zone = aresp.timezone;
    result_info.uid = aresp.uid;
    result_info.suid = aresp.suid;
    result_info.mdb = aresp.storage;
    TASK_LOG(ctx, info) << "bb info about (" << result_info.uid << ", " << result_info.suid
                        << "): " << result_info.mdb << ";" << time_zone << ";"
                        << result_info.timezone_offset << ", call time: "
                        << time_traits::to_string(time_traits::clock::now() - start_time);

    result.set(result_info);
}

}
