#pragma once

#include <yxiva/core/operation_result.h>
#include "decoders.h"
#include <yxiva/core/json.h>

namespace yxiva { namespace filter { namespace parser {

namespace detail {
inline operation::result append_rule(rules_t& rules, vars_t& vars, json_value const& rule_json)
{
    action rule_action = filter::action_from_string(json_get(rule_json, "action", string()));
    if (rule_action == action::unknown) return "unknown action";

    condition cond;
    auto condition_decoded = ::yxiva::filter::parser::decode_condition(cond, rule_json);
    if (!condition_decoded) return condition_decoded.error_reason;

    add_single_variable_rule(rules, vars, std::move(cond), rule_action);
    return operation::success;
}
}

inline operation::result decode_filter_v1(filter_set& dst, const json_value& data)
{
    auto& rules_json = data["rules"];
    if (rules_json.type() != json_type::tarray) return "no rules node";
    if (rules_json.type() != json_type::tarray) return "not array rules node";
    if (rules_json.size() == 0) return "empty rules array node";

    rules_t rules;
    vars_t vars;
    rules.reserve(rules_json.size());
    for (auto it = rules_json.array_begin(); it != rules_json.array_end(); ++it)
    {
        rule new_rule;
        auto decode_result = detail::append_rule(rules, vars, *it);
        if (!decode_result) return decode_result.error_reason;
    }

    action default_action = action::send_bright;
    auto& action_json = data["default_action"];
    if (action_json.type() == json_type::tstring)
    {
        default_action = filter::action_from_string(action_json.to_string());
        if (default_action == action::unknown) return "unknown default action";
    }

    dst = filter_set(std::move(rules), std::move(vars), default_action);
    return operation::success;
}

}}}
