#pragma once

#include <yxiva/core/operation_result.h>
#include <yxiva/core/filter.h>
#include <yxiva/core/json.h>
#include <string>

namespace yxiva { namespace filter { namespace parser {

using std::string;

inline operation::result decode_values(std::vector<string>& dst, json_value const& values_json)
{
    if (values_json.type() != json_type::tarray) return "no value array in rule";

    if (values_json.size() == 0) return "empty value array node";

    std::vector<string> values;
    for (auto it = values_json.array_begin(); it != values_json.array_end(); ++it)
    {
        if (!(*it).is_string()) return "not string value";
        values.push_back((*it).to_string());
    }
    dst = std::move(values);
    return operation::success;
}

inline operation::result decode_condition(condition& dst, const json_value& data)
{
    message_condition_type type;
    string key;
    std::vector<string> values;

    const json_value& condition_json = data["condition"];
    if (condition_json.type() != json_type::tstring) return "no condition string in rule";

    type = filter::condition_from_string(condition_json.to_string());
    if (type == message_condition_type::unknown) return "unknown condition";

    if (condition_uses_key(type))
    {
        key = json_get(data, "key", string());
        ;
        if (key.empty()) return "missing key in condition";
    }

    auto vals_decoded = decode_values(values, data["value"]);
    if (!vals_decoded) return vals_decoded;

    dst.type = type;
    dst.key = std::move(key);
    dst.value = std::move(values);

    return operation::success;
}

}}}
