#include <yxiva/core/json/merge.h>

namespace yxiva {

void json_merge(json_value_ref& dest, const json_value_ref& src, bool override)
{
    if (!src.is_object()) return;
    for (auto node = src.members_begin(); node != src.members_end(); node++)
    {
        if (override or not dest.has_member(node.key()))
        {
            dest[node.key()] = *node;
        }
    }
}

}
