#include <yxiva/core/json/parse.h>

namespace yxiva {

json_value json_parse(const string& data, json_type expected_type)
{
    if (data.empty())
    {
        if (expected_type == json_type::tnull) return json_value();
        throw std::runtime_error("unexpected json value type");
    }

    json_value value;
    if (auto error = value.parse(data))
    {
        throw std::runtime_error("error while parsing json: " + *error);
    }
    if (value.type() == expected_type)
    {
        return value;
    }
    else
    {
        throw std::runtime_error("unexpected json value type");
    }
}

json_value json_parse_no_type_check(const string& data)
{
    json_value value;
    if (auto error = value.parse(data))
    {
        throw std::runtime_error("error while parsing json: " + *error);
    }
    return value;
}

operation::result json_parse(
    json_value& dst,
    const string& raw_src,
    json_type expected_type) noexcept
{
    try
    {
        if (raw_src.empty())
        {
            if (expected_type == json_type::tnull)
            {
                dst = json_value();
                return operation::success;
            }
            else
            {
                return "no data";
            }
        }
        else
        {
            json_value value;
            if (auto error = value.parse(raw_src))
            {
                return "error while parsing json: " + *error;
            }

            if (value.type() == expected_type)
            {
                dst = std::move(value);
                return operation::success;
            }
        }

        return "unexpected json value type";
    }
    catch (const std::exception& e)
    {
        return string("json parsing exception: ") + e.what();
    }
}

}
