#include <yxiva/core/message.h>

namespace yxiva {

using message_flags_base = typename std::underlying_type<message_flags>::type;

bool message::has_tag(const std::string& tag_to_find) const
{
    for (const auto& tag : tags)
        if (tag == tag_to_find) return true;

    return false;
}

message_flags operator|(message_flags flag1, message_flags flag2)
{
    return static_cast<message_flags>(
        static_cast<message_flags_base>(flag1) | static_cast<message_flags_base>(flag2));
}

message_flags& operator|=(message_flags& flag1, message_flags flag2)
{
    flag1 = static_cast<message_flags>(
        static_cast<message_flags_base>(flag1) | static_cast<message_flags_base>(flag2));
    return flag1;
}

void message::set_flag(message_flags flag)
{
    flags |= flag;
}

void message::unset_flag(message_flags flag)
{
    flags = static_cast<message_flags>(
        static_cast<message_flags_base>(flags) & ~static_cast<message_flags_base>(flag));
}

bool message::has_flag(message_flags flag) const
{
    return (static_cast<message_flags_base>(flags) & static_cast<message_flags_base>(flag)) ==
        static_cast<message_flags_base>(flag);
}

}
