#include <yxiva/core/message_to_json.h>
#include <yplatform/time_traits.h>

namespace yxiva {

json_value message_to_json(const message& m)
{
    json_value result;

    // TODO decode topic names?

    result["uid"] = m.uid;
    result["service"] = m.service;
    result["operation"] = m.operation;
    result["session_key"] = m.session_key;
    json_value data;
    for (auto i = m.data.begin(); i != m.data.end(); ++i)
    {
        data[i->first] = i->second;
    }
    result["data"] = data;
    result["raw_data"] = m.raw_data;
    result["bright"] = m.bright;
    result["transit_id"] = m.transit_id;
    result["local_id"] = m.local_id;
    result["position"] = m.local_id;
    result["event_ts"] = yplatform::time_traits::to_simple_string(m.event_ts);
    auto&& tags = result["tags"];
    tags.set_array();
    for (auto&& tag : m.tags)
    {
        tags.push_back(tag);
    }
    auto&& repack = result["repack"];
    for (const auto& rule : m.repacking_rules)
        repack[rule.first] = rule.second;

    return result;
}

}
