#include <yxiva/core/methods/key_extractor.h>

namespace yxiva { namespace methods {

string key_extract_path(request_adaptor_ptr req)
{
    return key_extract_path_n(req->native_request(), 0);
}

string key_extract_path_stream(ymod_webserver::http::stream_ptr s)
{
    return key_extract_path_n(s->request(), 0);
}

string key_extract_path_root(ymod_webserver::request_ptr req)
{
    return key_extract_path_n(req, 0);
}

string key_extract_path_n(ymod_webserver::request_ptr req, const size_t index)
{
    if (index >= req->url.path.size())
    {
        return "";
    }
    else
    {
        return *(req->url.path.begin() + index);
    }
}

string make_full_path(const ymod_webserver::uri_path_t& path)
{
    typedef ymod_webserver::uri_path_t::const_iterator iterator;

    string result = "/";
    iterator it = path.begin();
    while (it != path.end())
    {
        result.append(*it);
        ++it;
        if (it != path.end()) result.append("/");
    }
    return result;
}

}}