#include <yxiva/core/methods/request_adaptor.h>

namespace yxiva {

request_adaptor::request_adaptor(request_ptr req, response_ptr res)
    : req_(req), res_(res), code_sent_(false)
{
}

void request_adaptor::set_code(ymod_webserver::codes::code code)
{
    res_->set_code(code);
    code_sent_ = true;
}

void request_adaptor::add_header(const string& name, const string& value)
{
    res_->add_header(name, value);
}

void request_adaptor::send_result(string const& message)
{
    if (code_sent_) res_->result_body(message);
    else
    {
        res_->result(ymod_webserver::codes::ok, message);
        code_sent_ = true;
    }
}

void request_adaptor::send_error(
    ymod_webserver::codes::code code,
    string const& message,
    string const& verbose)
{
    TASK_LOG(req_->context, error) << "response: " << code << " " << message << " " << verbose;
    if (code_sent_) res_->result_body(message);
    else
    {
        res_->result(code, message);
        code_sent_ = true;
    }
}

}
