#include <yxiva/core/nested_prefix_stream.h>

namespace yxiva {

nested_prefix_stream::nested_prefix_stream(std::ostream& impl) : impl_(impl)
{
}

void nested_prefix_stream::push(string const& prefix, bool add_space)
{
    prefix_items_.push_back(prefix + (add_space ? " " : ""));
    rebuild_prefix();
}

void nested_prefix_stream::push_not_empty(
    string const& prefix,
    string const& placeholder,
    bool add_space)
{
    push((prefix.empty() ? placeholder : prefix), add_space);
}

void nested_prefix_stream::pop()
{
    prefix_items_.pop_back();
}

void nested_prefix_stream::rebuild_prefix()
{
    prefix_.clear();

    for (string const& item : prefix_items_)
    {
        prefix_.append(item);
    }
}

}