#include <yxiva/core/notify_status_to_json.h>

namespace yxiva {

json_value to_json(const notify_status& status)
{
    static const char* JSON_FIELD_CODE("code");
    static const char* JSON_FIELD_BODY("body");
    static const char* JSON_FIELD_SUBSCRIPTION_ID("id");

    json_value result;
    result[JSON_FIELD_CODE] = status.code;

    if (status.body.size() && status.body[0] == '{')
    {
        json_value json_body;
        if (auto error = json_body.parse(status.body))
        {
            result[JSON_FIELD_BODY] = status.body;
        }
        else
        {
            result[JSON_FIELD_BODY] = json_body;
        }
    }
    else
    {
        result[JSON_FIELD_BODY] = status.body;
    }

    if (status.subscription_id.size())
    {
        result[JSON_FIELD_SUBSCRIPTION_ID] = status.subscription_id;
    }

    return result;
}

}
