#include <yxiva/core/resharding/migration.h>
#include <yplatform/util/sstream.h>

namespace yxiva { namespace resharding {

string migration::describe() const
{
    string res;
    yplatform::sstream(res, 20) << "[" << start_gid << ", " << end_gid << "]"
                                << ": " << to_string(state);
    return res;
}

json_value migration::to_json() const
{
    json_value migration_node;
    migration_node["state"] = to_string(state);
    migration_node["start_gid"] = start_gid;
    migration_node["end_gid"] = end_gid;
    return migration_node;
}

json_value to_json(const migrations& migrations)
{
    json_value result(json_type::tarray);
    for (auto&& m : migrations)
    {
        result.push_back(m.to_json());
    }
    return result;
}

bool operator==(const migration& lhs, const migration& rhs)
{
    return lhs.state == rhs.state && lhs.start_gid == rhs.start_gid && lhs.end_gid == rhs.end_gid;
}

bool operator!=(const migration& lhs, const migration& rhs)
{
    return !operator==(lhs, rhs);
}

bool operator<(const migration& lhs, const migration& rhs)
{
    return lhs.end_gid < rhs.end_gid;
}

const string& to_string(migration::state_type state)
{
    using s = migration::state_type;

    static const string pending = "pending";
    static const string ready = "ready";
    static const string inprogress = "inprogress";
    static const string finished = "finished";
    static const string unknown = "unknown";

    switch (state)
    {
    case s::pending:
        return pending;
    case s::ready:
        return ready;
    case s::inprogress:
        return inprogress;
    case s::finished:
        return finished;
    }

    return unknown;
}

}}