#include <yxiva/core/services/csv_decoder.h>

#include <map>
#include <boost/assign.hpp>
#include <yxiva/core/parameter_names.h>

namespace yxiva { namespace services {

csv_decoder::csv_decoder(const string& name) : name_(name)
{
}

void csv_decoder::decode(const ymod_webserver::request_ptr& req, message& msg) const
{
    msg.service = name();
    msg.uid = req->url.param_value("uid", "");
    msg.raw_data = req->url.param_value("raw_data", "");
    msg.operation = req->url.param_value("operation", "");
    msg.lcn = req->url.param_value("lcn", "");
    msg.session_key = req->url.param_value(yxiva::parameters::SESSION_KEY, "");

    // parse data
    const string& data_block = req->url.param_value("data", "");
    string::const_iterator begin = data_block.begin();
    string::const_iterator end = data_block.end();
    string::const_iterator current = begin;
    if (current == end || *current != 13) return;
    string name, value;
    while (current != end)
    {
        name.clear();
        value.clear();
        for (begin = ++current; current != end && *current != ':'; ++current)
            ;
        name.append(begin, current);
        if (current == end) break;
        for (begin = ++current; current != end && *current != 13; ++current)
            ;
        value.append(begin, current);
        if (!name.empty())
        {
            if (name == "lcn")
            {
                msg.lcn = value;
            }
            else if (name == "operation")
            {
                msg.operation = value;
            }
            else if (name == yxiva::parameters::SESSION_KEY)
            {
                msg.session_key = value;
            }
            msg.data[name] = value;
        }
    }
}

const string& csv_decoder::name() const
{
    return name_;
}

}}
