#include <yxiva/core/services/msgpack_decoder.h>

#include <map>
#include <boost/assign.hpp>
#include <yxiva/core/services/names.h>
#include <yxiva/core/packing.hpp>

namespace yxiva { namespace services {

msgpack_decoder::msgpack_decoder(const string& name) : name_(name)
{
}

void msgpack_decoder::decode(const ymod_webserver::request_ptr& req, message& msg) const
{
    std::string buf;
    buf.reserve(req->raw_body.size());
    buf.assign(req->raw_body.begin(), req->raw_body.end());
    unpack(buf, msg);
    if (msg.service.empty())
    {
        throw std::runtime_error("msgpack_decoder::decode: no service in the message");
    }
}

const string& msgpack_decoder::name() const
{
    return name_;
}

}}
