#include <yxiva/core/services/simple_http_decoder.h>

#include <map>
#include <boost/assign.hpp>
#include <yxiva/core/parameter_names.h>

namespace yxiva { namespace services {

simple_http_decoder::simple_http_decoder(const string& name) : name_(name)
{
}

void simple_http_decoder::decode(const ymod_webserver::request_ptr& req, message& msg) const
{
    msg.uid = req->url.param_value("uid", "");
    msg.service = name();

    msg.lcn = req->url.param_value("lcn", "");
    msg.operation = req->url.param_value("operation", "");
    msg.session_key = req->url.param_value(parameters::SESSION_KEY, "");
    if (msg.session_key.empty()) msg.session_key = req->url.param_value("connection_id", "");

    msg.raw_data = string(req->raw_body.begin(), req->raw_body.end());
}

const string& simple_http_decoder::name() const
{
    return name_;
}

}}
