#include "yxiva/core/subscription_id.h"
#include <yxiva/core/platforms.h>
#include <yplatform/hash/sha1.h>

namespace yxiva {

string make_subscription_id(
    const string& uid,
    const string& service,
    const string& callback,
    const string& client,
    const string& session,
    const string& filter,
    const string& extra)
{
    std::ostringstream ss;
    ss << uid << service << callback << extra << client << session << filter;
    return yplatform::sha1(ss.str());
}

string make_subscription_id(const sub_t& subscription)
{
    return make_subscription_id(
        subscription.uid,
        subscription.service,
        subscription.callback_url,
        subscription.client,
        subscription.session_key,
        subscription.filter,
        subscription.extra_data);
}

string make_mobile_subscription_id(const string& device_uuid)
{
    return "mob:" + canonize_device_id(device_uuid);
}

string make_webpush_subscription_id(const string& session)
{
    return "webpush:" + session;
}

namespace websocket_id_generator {

string make_default(
    const string& uid,
    const string& service,
    const string& callback,
    const string& client,
    const string& session,
    const string& filter,
    const string& extra)
{
    return make_subscription_id(uid, service, callback, client, session, filter, extra);
}

string make_from_session(
    const string& /*uid*/,
    const string& /*service*/,
    const string& /*callback*/,
    const string& /*client*/,
    const string& session,
    const string& /*filter*/,
    const string& /*extra*/)
{
    return session;
}

}

}
