#include <yxiva/core/ec_crypto.h>
#include <catch.hpp>
#include <fstream>
#include <string>

using namespace yxiva::ec_crypto;
using string = std::string;

static const string private_key_filename = "p8_test_token.key";

static const string private_key_str{ []() {
    std::ifstream ifstream(private_key_filename);
    string str((std::istreambuf_iterator<char>(ifstream)), std::istreambuf_iterator<char>());
    return str;
}() };

static const string data_str = R"(
8g/6CbLhQ0Bmf02pB9bzpAjZaPDjAVyW5RL99wavW/vJ9EnwAiYcqaSW126PAIUs
2zjmwhAkrZYqeFMKzj+4dqsjqESoF4NbScS5vDBOdlvguzrPX5dclvuLs93EXGkJ
cLRsbYR9uzu0VPmtUoZXIZk33pvFWbbiid7rIoh5SM8=
)";

static const std::vector<unsigned char> sign_valid{
    0x55, 0x55, 0xC4, 0x8C, 0xC5, 0x12, 0x39, 0x5A, 0x6F, 0xB6, 0x5A, 0x00, 0x8C, 0x42, 0x39, 0x81,
    0x1B, 0x1A, 0x79, 0xC8, 0x11, 0xA2, 0x60, 0x12, 0xA5, 0x8D, 0xED, 0x27, 0x19, 0x86, 0xC2, 0x40,
    0x60, 0xBE, 0xF0, 0xA4, 0x7C, 0x70, 0x2B, 0x44, 0xB5, 0x50, 0xB5, 0xA3, 0x08, 0x86, 0xBE, 0xB8,
    0x6E, 0xD4, 0xD3, 0x9D, 0xA2, 0xF8, 0x29, 0x63, 0x08, 0x4C, 0xEB, 0xA9, 0x7D, 0xF9, 0x1C, 0x28
};

static const std::vector<unsigned char> sign_invalid{
    0x55, 0x55, 0xC4, 0x8C, 0xC5, 0x12, 0x39, 0x5A, 0x6F, 0xB6, 0x5A, 0x00, 0x8C, 0x42, 0x39, 0x81,
    0x1B, 0x1A, 0x79, 0xC8, 0x11, 0xB2, 0x60, 0x12, 0xA5, 0x8D, 0xED, 0x27, 0x19, 0x86, 0xC2, 0x40,
    0x60, 0xBE, 0xF0, 0xA4, 0x7C, 0x70, 0x2B, 0x44, 0xB5, 0x50, 0xB5, 0xA3, 0x08, 0x86, 0xBE, 0xB8,
    0x6E, 0xD4, 0xD3, 0x9D, 0xA2, 0xF8, 0x29, 0x63, 0x08, 0x4C, 0xEB, 0xA9, 0x7D, 0xF9, 0x1C, 0x28
};

TEST_CASE("ec_crypto::read_pem/verify_ok", "")
{
    auto priv_key = read_pem(private_key_filename);
    REQUIRE(verify_sign(data_str.data(), data_str.size(), sign_valid, priv_key));
}

TEST_CASE("ec_crypto::read_pem/verify_fails", "")
{
    auto priv_key = read_pem(private_key_filename);
    REQUIRE(!verify_sign(data_str.data(), data_str.size(), sign_invalid, priv_key));
}

TEST_CASE("ec_crypto::read_pem_buf/verify_ok", "")
{
    auto priv_key = read_pem_buf(private_key_str);
    REQUIRE(verify_sign(data_str.data(), data_str.size(), sign_valid, priv_key));
}

TEST_CASE("ec_crypto::read_pem_buf/verify_fails", "")
{
    auto priv_key = read_pem_buf(private_key_str);
    REQUIRE(!verify_sign(data_str.data(), data_str.size(), sign_invalid, priv_key));
}
