LIBRARY()

OWNER(g:xiva)
NO_UTIL()

ADDINCL(
    GLOBAL mail/xiva/core/include
    GLOBAL mail/xiva/msgpack/include
)

PEERDIR(
    mail/yplatform/lib
    mail/ymod_webserver
    mail/ymod_httpclient
    mail/ymod_blackbox
    contrib/restricted/boost/crc
    contrib/restricted/boost/libs
    contrib/python/msgpack
 )

SRCS(
    src/shards/shards.cc
    src/resharding/migration.cc
    src/methods/key_extractor.cc
    src/methods/request_adaptor.cc
    src/repacker.cc
    src/subscription_id.cc
    src/ec_crypto.cc
    src/auth/caching_authorizer.cc
    src/auth/authorizer.cc
    src/message_to_json.cc
    src/notify_status_to_json.cc
    src/platforms/apns.cc
    src/platforms/apns_queue.cc
    src/user_info.cc
    src/callbacks.cc
    src/json/parse.cc
    src/json/merge.cc
    src/json/decoder.cc
    src/json/write.cc
    src/nested_prefix_stream.cc
    src/message.cc
    src/filter/parse.cc
    src/filter/filter_set.cc
    src/x509.cc
    src/asn1/time.cc
    src/services/names.cc
    src/services/decoder.cc
    src/services/csv_decoder.cc
    src/services/msgpack_decoder.cc
    src/services/simple_http_decoder.cc
)

PY_SRCS(
    TOP_LEVEL
    pycommon/__init__.py
    pycommon/api_test_base.py
    pycommon/assert_response.py
    pycommon/asserts.py
    pycommon/empty.py
    pycommon/fake_server.py
    pycommon/hub.py
    pycommon/wait_condition.py
    pycommon/xivamob_api.py
    pycommon/xiva_api.py
)

END()

RECURSE(
    tests
)
