#!/bin/bash

[[ "$TRACE" ]] && set -x
set -eo pipefail

cat /var/log/xivacrm/xivacrm.log | awk -v ts=$(date +%s) '
    /new_user/ {
        match($0, /platform=([^ ]+)/, platform);
        match($0, /locale=([^ ]+)/, locale);
        match($0, /timezone=([^ ]+)/, timezone);
        by_platform[platform[1]] += 1
        by_locale[locale[1]] += 1
        by_timezone[timezone[1]] += 1
    }

    END {
        for (i in by_platform) {
            print "new_users.platform." i, by_platform[i], ts
        }
        for (i in by_locale) {
            print "new_users.locale." i, by_locale[i], ts
        }
        for (i in by_timezone) {
            print "new_users.timezone." i, by_timezone[i], ts
        }
    }'
