#!/bin/bash

[[ "$TRACE" ]] && set -x
set -eo pipefail

cat /var/log/xivacrm/xivacrm.log | awk -v ts=$(date +%s) '
    /send to xiva finish/ {
        match($0, /campaign=([^ ]+)/, campaign);
        match($0, /step=([^ ]+)/, step);
        match($0, /status_code=([^ ]+)/, status_code);
        status[campaign[1] "." step[1] "." status_code[1]] += 1

        match($0, /codes=([^ ]+)/, codes_raw);
        split(codes_raw[1], codes, ",");
        for (i in codes) {
            code[campaign[1] "." step[1] "." codes[i]] += 1
        }
    }

    END {
        for (i in status) {
            print "xiva.status." i, status[i], ts
        }
        for (i in code) {
            print "xiva.code." i, code[i], ts
        }
    }'
