from mail.xiva.crm.src.util import cur_utc_ts
import logging


class HistoryYT:
    def __init__(self, client, yt_paths):
        self.client = client
        self.yt_paths = yt_paths
        self.logger = logging.getLogger("global")

    def write(self, events):
        self.logger.info('write events {}'.format(str(events)))
        if len(events) == 0:
            return
        entries = ",".join("('{}', '{}', DateTime::TimestampFromMicroSeconds({}))".format(
            event['name'], event['data'], cur_utc_ts()) for event in events)
        query = """
            INSERT INTO [{history}] (event_name, event_data, timestamp)
            VALUES {entries};
        """.format(history=self.yt_paths.HISTORY, entries=entries)
        request = self.client.query(query=query)
        request.run()
        request.get_results()


class FakeHistory:
    def __init__(self):
        self.events = []

    def write(self, events):
        self.events += events
