import datetime
import json
import os.path
import time


class LocalStorage:
    def __init__(self, path):
        self.path = path
        if os.path.isfile(path):
            self.state = json.loads(open(path, 'r').read().strip())
        else:
            self.state = {}

    def get(self, key, defval=None):
        return self.state[key] if key in self.state else defval

    def set(self, key, val):
        self.state[key] = val
        open(self.path, 'w').write(json.dumps(self.state))

    def get_datetime(self, key, defval=None):
        val = self.get(key)
        if val is None:
            return defval
        return defval if val is None else datetime.datetime.fromtimestamp(val)

    def set_datetime(self, key, val):
        self.set(key, time.mktime(val.timetuple()))


class FakeLocalStorage:
    def __init__(self):
        self.state = {}

    def get(self, key, defval=None):
        return self.state[key] if key in self.state else defval

    def set(self, key, val):
        self.state[key] = val

    def get_datetime(self, key, defval=None):
        val = self.get(key)
        if val is None:
            return defval
        return defval if val is None else datetime.datetime.fromtimestamp(val)

    def set_datetime(self, key, val):
        self.set(key, time.mktime(val.timetuple()))
