import time
import datetime
import copy
import yaml


class YtPaths:
    def __init__(self, config):
        self.ROOT = config['root']
        self.HISTORY = self.ROOT + "/history"
        self.SCHEDULE = self.ROOT + "/schedule"
        self.PLAN = self.ROOT + "/device_plan"
        self.HISTORY = self.ROOT + "/history"
        self.DEVICES = self.ROOT + "/devices"
        self.USERS = self.ROOT + "/users"
        self.USER_DEVICE = self.ROOT + "/user_device"
        self.METRIKA_ROOT = config['metrika_root']
        self.METRIKA_5M = self.METRIKA_ROOT + "/stream/5min"
        self.METRIKA_1D = self.METRIKA_ROOT + "/1d"
        self.XENO_ROOT = config['xeno_root']
        self.XENO_5M = self.XENO_ROOT + "/stream/5min"
        self.XENO_1D = self.XENO_ROOT + "/1d"


def to_microseconds(seconds):
    return seconds * 10**6


def from_microseconds(microseconds):
    return microseconds / 10**6


def cur_utc_ts():
    return int(to_microseconds(time.time()))


def date_time_to_ts(dt):
    return to_microseconds(time.mktime(dt.timetuple()))


def date_time_from_ts(ts):
    return datetime.datetime.fromtimestamp(from_microseconds(ts))


def date_and_time_to_ts(dt, tm, timezone):
    date_time = datetime.datetime.combine(dt, tm) + datetime.timedelta(seconds=(10800 - timezone))
    return to_microseconds(time.mktime(date_time.timetuple()))


def calc_next_step_ts(time_list, step_check_time, timezone, allow_cur_day=True):
    cur_ts = cur_utc_ts()
    if len(time_list) == 0:
        return {
            'execute_ts': cur_ts,
            'begin_ts': cur_ts,
            'end_ts': cur_ts + to_microseconds(3600)  # +1 hour
        }
    for days in range(0 if allow_cur_day else 1, 2):
        dt = datetime.date.today() + datetime.timedelta(days=days)
        for [begin_time_str, end_time_str] in time_list:
            begin_time = datetime.time(int(begin_time_str[:2]), int(begin_time_str[3:]))
            begin_ts = date_and_time_to_ts(dt, begin_time, timezone)
            end_time = datetime.time(int(end_time_str[:2]), int(end_time_str[3:]))
            end_ts = date_and_time_to_ts(dt, end_time, timezone)
            execute_ts = begin_ts - to_microseconds(step_check_time * 60)
            if execute_ts > cur_ts:
                return {
                    'execute_ts': execute_ts,
                    'begin_ts': begin_ts,
                    'end_ts': end_ts
                }
    raise Exception(
        'next step ts not found: cur_ts={} time_list={} timezone={} allow_cur_day={}'
        .format(cur_ts, time_list, timezone, allow_cur_day))


def merge(lhs, rhs):
    ret = {}
    for k, v in lhs.iteritems():
        if type(v) == dict and k in rhs and type(rhs[k]) == dict:
            ret[k] = merge(v, rhs[k])
        elif type(v) == list and k in rhs and type(rhs[k]) == list:
            ret[k] = copy.deepcopy(v) + copy.deepcopy(rhs[k])
        else:
            ret[k] = copy.deepcopy(v)
    for k, v in rhs.iteritems():
        if k not in lhs:
            ret[k] = copy.deepcopy(v)
    return ret


def load_config(path):
    config = yaml.load(open(path, 'r'))
    if 'base' in config:
        base = load_config(config['base'])
        return merge(config['config'], base)
    else:
        return config['config']
