import json
import thread
import logging
from socket import AF_INET6
from BaseHTTPServer import BaseHTTPRequestHandler, HTTPServer


class Web(HTTPServer):
    address_family = AF_INET6

    class Handler(BaseHTTPRequestHandler):
        def do_GET(self):
            self.process_query()

        def do_POST(self):
            self.process_query()

        def process_query(self):
            if self.path[:5] == '/list':
                status = 200
                resp = json.dumps(self.server.scheduler.schedule)
            elif self.path[:9] == '/schedule':
                body = self.rfile.read(int(self.headers.getheader('content-length', 0)))
                self.server.scheduler.schedule_tasks(json.loads(body))
                status = 200
                resp = "OK"
            elif self.path[:5] == '/stop':
                self.server.scheduler.stop()
                status = 200
                resp = "OK"
                self.server.logger.info("stop")
            elif self.path[:6] == '/start':
                self.server.scheduler.start()
                status = 200
                resp = "OK"
                self.server.logger.info("start")
            else:
                status = 404
                resp = "Not found"
            self.send_response(status)
            self.send_header('Content-Length', len(resp))
            self.end_headers()
            self.wfile.write(resp)

        def log_message(self, fmt, *args):
            self.server.logger.info(fmt % args)

    def __init__(self, port, scheduler):
        HTTPServer.__init__(self, ('', port), Web.Handler)
        self.scheduler = scheduler
        self.logger = logging.getLogger("global")

    def start(self):
        thread.start_new_thread(self.serve_forever, ())
