DROP SCHEMA IF EXISTS xiva_loadtest CASCADE;

CREATE SCHEMA xiva_loadtest;
CREATE FUNCTION xiva_loadtest.uid(uid_number bigint)
RETURNS text LANGUAGE SQL AS
$$
    SELECT md5(uid_number::text);
$$;

CREATE FUNCTION xiva_loadtest.random_text(len integer)
RETURNS text LANGUAGE plpgsql AS
$$
DECLARE
    ret text;
BEGIN
    -- Randomize length a little.
    len := len + trunc(random() * len / 2 - len / 4);
    ret := '';
    IF len <= 0 THEN
        RETURN ret;
    END IF;
    WHILE char_length(ret) < len LOOP
        ret := ret || md5(random()::text);
    END LOOP;
    ret := substring(ret from 1 for len);
    RETURN ret;
END
$$;

GRANT USAGE ON SCHEMA xiva_loadtest TO xiva_user;
GRANT ALL on ALL TABLES IN SCHEMA xiva_loadtest TO xiva_user;
GRANT EXECUTE ON ALL FUNCTIONS IN SCHEMA xiva TO xiva_user;
