-- Generate counters
WITH sids(sid) AS (
    SELECT sid FROM xiva.services
), uid_numbers(uid_number) AS (
    SELECT * FROM generate_series(%(uid_start)s, %(uid_end)s)
) INSERT INTO xiva.counters(uid, sid, total_count, next_local_id, last_seen_id)
    SELECT
        xiva_loadtest.uid(uid_number),
        sids.sid,
        %(notifications_per_uid)s,
        %(notifications_per_uid)s + 1,
        %(notifications_per_uid)s
    FROM sids, uid_numbers;

-- Generate notifications
WITH local_ids(local_id) AS (
    SELECT * FROM generate_series(1, %(notifications_per_uid)s)
), uid_numbers(uid_number) AS (
    SELECT * FROM generate_series(%(uid_start)s, %(uid_end)s)
) INSERT INTO xiva.notifications(
    uid,
    sid,
    local_id,
    event_dt,
    is_deleted,
    is_sticked,
    delayed_until_dt,
    extra_data,
    ttl,
    content,
    hash,
    transit_id,
    topic)
    SELECT
        xiva_loadtest.uid(uid_number),
        trunc(random() * %(services)s + 1.0),
        local_ids.local_id,
        now(),
        FALSE,
        FALSE,
        NULL,
        xiva_loadtest.random_text(%(extra_length)s),
        100500,
        xiva_loadtest.random_text(%(content_length)s)::bytea,
        xiva_loadtest.random_text(%(hash_length)s),
        xiva_loadtest.random_text(%(transit_id_length)s),
        ''
    FROM local_ids, uid_numbers;