WITH sub_numbers(sub_number) AS (
    SELECT * FROM generate_series(1, %(subs_per_uid)s)
), uid_numbers(uid_number) AS (
    SELECT * FROM generate_series(%(uid_start)s, %(uid_end)s)
) INSERT INTO xiva.subscriptions(uid, gid, service, id, callback, filter,
    extra_data, client, ttl, session_key, init_local_id, init_time, platform,
    device, bb_connection_id, uidset, ack_local_id, ack_time, smart_notify,
    next_retry_time, retry_interval, ack_event_ts)
    SELECT
        xiva_loadtest.uid(uid_number), -- uid
        (uid_number %% 65535)::int, -- gid
        %(service)s, -- service
        xiva_loadtest.random_text(%(id_length)s), -- id
        xiva_loadtest.random_text(%(text_length)s), -- callback
        xiva_loadtest.random_text(%(id_length)s), -- filter
        xiva_loadtest.random_text(%(extra_length)s), -- extra
        xiva_loadtest.random_text(%(text_length)s), -- client
        24, -- ttl
        xiva_loadtest.random_text(%(text_length)s), -- session_key
        0, now(), NULL, NULL, NULL, NULL,
        0, now(), FALSE, NULL, NULL, NULL
    FROM
        uid_numbers, sub_numbers
ON CONFLICT DO NOTHING;
