CREATE FUNCTION xiva_loadtest.subscribe(uid_number bigint, i_service text,
    id_length int, text_length int, extra_length int)
RETURNS INT LANGUAGE SQL AS
$$
    SELECT code.add_subscription(
        xiva_loadtest.uid(uid_number), -- uid
        (uid_number %% 65535)::int, -- gid
        i_service, -- service
        xiva_loadtest.random_text(id_length), -- id
        xiva_loadtest.random_text(text_length), -- callback
        xiva_loadtest.random_text(id_length), -- filter
        xiva_loadtest.random_text(extra_length), -- extra
        xiva_loadtest.random_text(text_length), -- client
        24, -- ttl
        xiva_loadtest.random_text(text_length), -- session_key
        0, NULL, NULL, NULL, NULL,
        'off' -- synchronous_commit
    );
$$;

CREATE FUNCTION xiva_loadtest.remove_old_subscriptions(i_del_fraction real)
RETURNS VOID LANGUAGE plpgsql AS
$$
DECLARE
    uid_ranges text[];
    length integer;
BEGIN
    uid_ranges := code.return_uid_ranges();
    IF uid_ranges IS NULL THEN
        DELETE FROM xiva.subscriptions
        WHERE random() < i_del_fraction;
    ELSE
        length := array_length(uid_ranges, 1);
        FOR pos in 1..length - 1 LOOP
            DELETE FROM xiva.subscriptions
            WHERE uid BETWEEN uid_ranges[pos] AND uid_ranges[pos + 1]
                AND (now() - init_time >= make_interval(hours => ttl)
                    OR random() < i_del_fraction);
        END LOOP;
    END IF;
END
$$;

TRUNCATE xiva.subscriptions CASCADE;
