CREATE SCHEMA IF NOT EXISTS xconf;

CREATE SEQUENCE xconf.conf_rev_seq START WITH 1 INCREMENT BY 1;

--endpoint and client conf types are now deprecated
CREATE TYPE xconf.conf_type AS ENUM (
    'service',
    'endpoint',
    'client',
    'mobile'
);

CREATE TABLE xconf.tokens (
    token  text  NOT NULL,
    CONSTRAINT uk_token UNIQUE (token),
    CONSTRAINT ch_token_empty CHECK (token <> '')
);

CREATE TABLE xconf.configurations (
    revision          bigint           NOT NULL DEFAULT nextval('xconf.conf_rev_seq'),
    type              xconf.conf_type  NOT NULL,
    name              text             NOT NULL,
    settings          bytea            NOT NULL,
    token             text,
    registration_date timestamp with time zone    NOT NULL DEFAULT current_timestamp,
    update_date       timestamp with time zone    NOT NULL DEFAULT current_timestamp,

    CONSTRAINT uk_type_name UNIQUE (type, name),
    CONSTRAINT uk_conf_token UNIQUE (token),
    CONSTRAINT fk_token FOREIGN KEY (token) REFERENCES xconf.tokens (token)
);

CREATE TYPE xconf.error_code_type AS ENUM (
    'token_violation'
);

CREATE TYPE xconf.put_list_type AS (
    revision bigint, error xconf.error_code_type
);

