#!/bin/bash

DB_PASSWORD=$1
DB_MIGRATION=$2
DB_PORT=$3

if [[ -z "$DB_PASSWORD" ]]; then
    echo "please, provide password for db user xiva_user as first argument: ./run.sh <xiva_password>"
    exit 1
fi

[[ $DB_MIGRATION ]] || DB_MIGRATION=latest
[[ $DB_PORT ]] || DB_PORT=6432

docker build --pull -t 'xstore_standalone' --network=host . && docker run \
    --env DB_PORT=$DB_PORT \
    --env DB_NAME=xivadb \
    --env DB_USER=xiva_user \
    --env DB_PASSWORD=$DB_PASSWORD \
    --env DB_MIGRATION=$DB_MIGRATION \
    --rm --name 'xiva_xstore_standalone' --network=host 'xstore_standalone'
