#!/bin/bash
set -e

psql -c "CREATE USER monitor;"
psql -c "CREATE USER $DB_USER WITH PASSWORD '$DB_PASSWORD';"
psql -c "CREATE DATABASE $DB_NAME;"
psql "user=postgres dbname=$DB_NAME" -c "CREATE EXTENSION pg_partman; GRANT ALL ON part_config TO $DB_USER;"

cd /src && pgmigrate -c "user=postgres dbname=$DB_NAME" -t $DB_MIGRATION -a "afterAll:code/,afterAll:grants/" migrate -v --verbose

echo "port = $DB_PORT" >> "${PGDATA}/postgresql.conf"
