CREATE FUNCTION code.h_int(text)
RETURNS int AS $$
 select ('x'||substr(md5($1),1,8))::bit(32)::int;
$$ language sql;

CREATE FUNCTION code.init_counters(
    i_uid text,
    i_sid bigint
) RETURNS void AS $$
DECLARE
    already_inited boolean;
BEGIN
    PERFORM pg_advisory_xact_lock(code.h_int(i_uid));

    SELECT COUNT(*)::int::boolean
        INTO already_inited FROM xiva.counters
        WHERE uid = i_uid AND sid = i_sid;

    IF already_inited THEN
        RETURN;
    END IF;

    INSERT INTO xiva.counters (uid, sid)
        VALUES (i_uid, i_sid);

END;
$$ LANGUAGE plpgsql;
