CREATE FUNCTION code.init_service(
    i_name text
) RETURNS bigint AS $$
DECLARE
    already_exist boolean;
    service_id bigint;
BEGIN
    SELECT sid INTO service_id FROM xiva.services WHERE service_name = i_name;
    IF service_id THEN
        RETURN service_id;
    END iF;

    PERFORM pg_advisory_xact_lock(-1);
    SELECT sid INTO service_id FROM xiva.services WHERE service_name = i_name;
    IF NOT FOUND THEN
        INSERT INTO xiva.services (service_name) values (i_name) RETURNING sid into service_id;
    END IF;

    RETURN service_id;
END;
$$ LANGUAGE plpgsql;
