CREATE FUNCTION code.resolve_services(i_sids bigint[])
RETURNS text[] AS $$
DECLARE
    result text[];
BEGIN
    SELECT array_agg(service_name)
        INTO result
        FROM xiva.services
        WHERE sid = ANY(i_sids);

    IF array_length(i_sids, 1) = array_length(result, 1) THEN
        RETURN result;
    ELSE
        RAISE EXCEPTION 'Some of the given sids have not been found';
    END IF;
END;
$$ LANGUAGE plpgsql;
