CREATE FUNCTION code.resolve_sids(i_services text[])
RETURNS bigint[] AS $$
DECLARE
    result bigint[];
BEGIN
    SELECT array_agg(sid)
        INTO result
        FROM xiva.services
        WHERE service_name = ANY(i_services);

    IF array_length(i_services, 1) != array_length(result, 1) THEN
        RAISE NOTICE 'Some of the given services have not been found';
    END IF;
    RETURN result;
END;
$$ LANGUAGE plpgsql;
