CREATE FUNCTION code.list_sid_notifications(
    i_uid text,
    i_sid bigint,
    i_last_hours integer,
    i_limit integer
) RETURNS SETOF xiva.notifications_list_type AS $$
DECLARE
    begin_ts timestamp with time zone;
BEGIN
    SELECT current_timestamp - (i_last_hours || ' hours')::interval
        INTO begin_ts;

    RETURN QUERY SELECT n.uid, s.service_name, n.local_id,
        ROUND(EXTRACT(EPOCH FROM n.event_dt))::bigint AS event_ts,
        NULL, n.ttl, n.content, n.is_deleted,
        n.is_sticked, ROUND(EXTRACT(EPOCH FROM n.delayed_until_dt))::bigint
            AS delayed_until_ts, topic
      FROM xiva.notifications n,
        xiva.services s,
        xiva.counters c
      WHERE n.sid = s.sid AND s.sid = i_sid AND s.sid = c.sid
        AND c.uid = i_uid AND c.uid = n.uid
        AND n.event_dt >= begin_ts
        AND n.event_dt >= COALESCE(c.last_seen_dt, n.event_dt)
        AND n.local_id > COALESCE(c.last_seen_id, 0)
        AND n.event_dt <= n.event_dt + (n.ttl || ' hours')::interval
      ORDER BY local_id DESC
      LIMIT i_limit;
END;
$$ LANGUAGE plpgsql;
