CREATE FUNCTION code.get_counters(
    i_uid text,
    i_services text[]
) RETURNS SETOF xiva.counters_list_type AS $$
BEGIN
    RETURN QUERY
        WITH services_info AS (
        SELECT sid, service_name
            FROM xiva.services
            WHERE service_name=ANY(i_services)
        )
    SELECT c.uid, s.service_name,
        total_count, unseen_count,
        next_local_id, last_seen_id,
        ROUND(EXTRACT(EPOCH FROM last_seen_dt))::bigint
            AS last_seen_ts
        FROM services_info s, xiva.counters c
        WHERE s.sid = c.sid
            AND c.uid = i_uid;
END;
$$ LANGUAGE plpgsql;
