CREATE OR REPLACE FUNCTION code.get_range_counters(
    i_uid text,
    i_services text[],
    i_begin_ts timestamp with time zone,
    i_begin_local_id bigint DEFAULT NULL,
    i_limit bigint DEFAULT NULL
) RETURNS SETOF xiva.range_counters_list_type AS $$
DECLARE
    end_ts timestamp with time zone;
    s record;
BEGIN
    SELECT current_timestamp + '1 hours'::interval INTO end_ts;

    FOR s IN
        SELECT sid, service_name
            FROM xiva.services
            WHERE service_name=ANY(i_services)
    LOOP
        RETURN QUERY
            WITH local_ids AS (
                SELECT local_id
                    FROM xiva.notifications
                    WHERE uid = i_uid
                        AND sid = s.sid
                        AND local_id > COALESCE(i_begin_local_id, 0)
                        AND event_dt >= i_begin_ts
                        AND event_dt <= end_ts
                    ORDER BY local_id DESC
                    LIMIT i_limit)
            SELECT
                i_uid,
                s.service_name,
                COALESCE(min(local_id), 0) as start_id,
                COALESCE(max(local_id), 0) as total_count
                FROM local_ids;
    END LOOP;
END;
$$ LANGUAGE plpgsql;
