CREATE FUNCTION code.list_notifications(
    i_uid text,
    i_services text[],
    i_last_hours integer,
    i_limit integer --per service
) RETURNS SETOF xiva.notifications_list_type AS $$
DECLARE
    s_id bigint;
BEGIN
    FOREACH s_id IN ARRAY code.resolve_sids(i_services) LOOP
        RETURN QUERY SELECT *
            FROM code.list_sid_notifications(i_uid,
                s_id, i_last_hours, i_limit);
    END LOOP;
    RETURN;
END;
$$ LANGUAGE plpgsql;
